/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util.cparser;

import com.ibm.hwmca.fw.util.cparser.ParserDataObj;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class CparserShort
extends ParserDataObj {
    private boolean byteSwap = true;

    public CparserShort() {
    }

    public CparserShort(int dataLength, boolean inValue, Method inMethod, Object invokeObject, boolean skipIfNull) {
        super(dataLength, inMethod, invokeObject, skipIfNull);
        this.setByteSwap(inValue);
    }

    public void setByteSwap(boolean inValue) {
        this.byteSwap = inValue;
    }

    public void setLength(int inputLength) {
        switch (inputLength) {
            case 1: 
            case 2: {
                super.setLength(inputLength);
                break;
            }
            default: {
                super.setLength(1);
            }
        }
    }

    public boolean isByteSwap() {
        return this.byteSwap;
    }

    int process(int offset, byte[] inputArray) throws IllegalAccessException, InvocationTargetException {
        short intValue = 0;
        if (this.dataLength + offset > inputArray.length) {
            return inputArray.length;
        }
        intValue = this.isByteSwap() ? CparserShort.toShortSwap(inputArray, this.dataLength, offset) : CparserShort.toShort(inputArray, this.dataLength, offset);
        boolean skipIt = false;
        if (this.isSkipIfNull() && intValue == 0) {
            skipIt = true;
            this.setSkipped(true);
        }
        if (!skipIt) {
            this.methodToCall.invoke(this.objectToInvoke, (Object[])new Short[]{new Short(intValue)});
        }
        return offset + this.dataLength;
    }
}

